#ifndef _DEVLOCALPLAYBACK_H
#define _DEVLOCALPLAYBACK_H
#include "dllexport.h"
class IDevUserLogin;
typedef enum enLocalFileType
{
	LFT_All = 0xFF,
	LFT_Manual = 0,
	LFT_AlarmTrigger,
	LFT_DownloadSave
} enLocalFileType;

typedef enum
{
	LPlayBack_Idle      = -1,
	LPlayBack_Pause     = 0,
	LPlayBack_Play      = 1,
	LPlayBack_TrickMode = 2,
} LPlayBackStatus;

class IDevLocalPlayback
{
public:
	virtual BOOL OpenFile(LPSTR sFileName) = 0;
	virtual BOOL CloseFile() = 0;
	virtual BOOL Play(HWND hWnd) = 0;
	virtual BOOL Stop() = 0;
	virtual BOOL Pause(DWORD nPause) = 0;
	virtual BOOL Fast() = 0;
	virtual BOOL Slow() = 0;
	virtual BOOL OneByOne() = 0;
	virtual BOOL OneByOneBack() = 0;
	virtual BOOL Capture(char *pFileName, BOOL bBmp = TRUE) = 0;
	virtual BOOL SetPlayPos(float fRelativePos) = 0;
	virtual float GetPlayPos() = 0;
	virtual BOOL SetFileEndMsg(HWND hWnd, UINT nMsg) = 0;
	virtual BOOL SetVolume(WORD nVolume) = 0;
	virtual BOOL StopSound() = 0;
	virtual BOOL PlaySound() = 0;
	virtual BOOL OpenStream(PBYTE pFileHeadBuf, DWORD nSize, DWORD nBufPoolSize) = 0;
	virtual BOOL InputData(PBYTE pBuf,DWORD nSize) = 0;
	virtual BOOL CloseStream() = 0;
	virtual int  GetCaps() = 0;
	virtual DWORD GetFileTime() = 0;
	virtual DWORD GetPlayedTime() = 0;
	virtual DWORD GetPlayedFrames() = 0;
};

class DLLAPI CDevLocalPlaybackFactory
{
public:
	static IDevLocalPlayback *CreateDevLocalPlayback(IDevUserLogin *pUser);
	static void DeleteDevLocalPlayback(IDevLocalPlayback *lp);
};

#endif
